/*
 * Decompiled with CFR 0.152.
 */
package builder.netsiddev.commands;

import builder.netsiddev.commands.NetSIDPkg;
import builder.netsiddev.commands.Write;
import java.util.ArrayList;
import java.util.List;
import server.netsiddev.Command;

public class TryWrite
implements NetSIDPkg {
    protected final List<Write> writes = new ArrayList<Write>();
    protected int cyclesSendToServer;

    public void addWrite(int cycles, byte reg, byte data) {
        this.writes.add(new Write(cycles, reg, data));
        this.cyclesSendToServer += cycles;
    }

    public int getCyclesSendToServer() {
        return this.cyclesSendToServer;
    }

    @Override
    public byte[] toByteArray() {
        int i = 0;
        byte[] cmd = new byte[4 + (this.writes.size() << 2)];
        cmd[i++] = (byte)Command.TRY_WRITE.ordinal();
        cmd[i++] = 0;
        cmd[i++] = 0;
        cmd[i++] = 0;
        for (Write write : this.writes) {
            cmd[i++] = (byte)(write.getCycles() >> 8 & 0xFF);
            cmd[i++] = (byte)(write.getCycles() & 0xFF);
            cmd[i++] = write.getReg();
            cmd[i++] = write.getData();
        }
        return cmd;
    }
}

